<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

class Checkout_Builder_Widget extends Widget_Base {

	public function get_name() {
		return 'checkout_builder_widget';
	}

	public function get_title() {
		return esc_html__( 'CoDesigner Checkout', 'codesigner-pro' );
	}

	public function get_icon() {
		$cd_branding_class = ' wlbi';
		return 'eicon-document-file' . $cd_branding_class;
	}

	public function get_categories() {
		return [ 'codesigner' ];
	}

	public function get_keywords() {
		return [ 'checkout', 'builder', 'template', 'file', 'document', 'design' ];
	}

    protected function register_controls() {
        /**
		 * content section
		 */
		$this->start_controls_section(
			'cd_checkout_content',
			[
				'label' 	    => __( 'Checkout Template', 'codesigner-pro' ),
				'tab' 		    => Controls_Manager::TAB_CONTENT,
			]
		);
		
		if( function_exists('is_checkout') && ! is_checkout() ) {
			$this->add_control(
				'checkout_template_set_important_note',
				[
					'label' => esc_html__( 'Important Note', 'codesigner-pro' ),
					'type' 	=> Controls_Manager::RAW_HTML,
					'raw' 	=> sprintf( __( "Set this page as WooCommerce Checkout Page!", 'codesigner-pro' ) ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
				]
			);
		}
        $this->add_control(
			'cd_checkout_template',
			[
				'label'         => esc_html__( 'Select Template', 'codesigner-pro' ),
				'type'          => Controls_Manager::SELECT2,
				'label_block'   => true,
				'multiple'      => false,
				'options'       => codesigner_get_checkout_templates_list( true ),
				'default'       => 'default',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'coupon_text',
			[
				'label'      => __( 'Coupon Text', 'codesigner-pro' ),
				'tab'        => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'coupon_label_txt',
			[
				'label'         => __( 'Label', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Have a Coupon', 'codesigner-pro' ),
				'placeholder'   => __( 'Type your title here', 'codesigner-pro' ),
			]
		);
		
		$this->add_control(
			'coupon_btn_txt',
			[
				'label'         => __( 'Button', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Enter Coupon', 'codesigner-pro' ),
				'placeholder'   => __( 'Type your title here', 'codesigner-pro' ),
			]
		);
		
		$this->add_control(
			'coupon_desc_txt',
			[
				'label'         => __( 'Button', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'If you have a coupon code, please apply it below.', 'codesigner-pro' ),
				'placeholder'   => __( 'Type your title here', 'codesigner-pro' ),
			]
		);
		$this->add_control(
			'coupon_apply_txt',
			[
				'label'         => __( 'Apply Button', 'codesigner-pro' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Apply Button', 'codesigner-pro' ),
				'placeholder'   => __( 'Type your title here', 'codesigner-pro' ),
			]
		);
		
		$this->end_controls_section();

		$templates_slug = codesigner_get_checkout_templates_list();
		foreach( $templates_slug as $template_slug ) {
			$args['control-slug'] 	= $template_slug;
			$args['this'] 			= $this;

			codesigner_get_checkout_template_controls( $args );
		}
    }

    protected function render() {
		if ( ! function_exists( 'is_checkout' ) ) return;

		// check post type and woocommerce checkout page id
		if ( get_post_type() == 'page' && get_option( 'woocommerce_checkout_page_id' ) == get_the_ID() ) {
			$cb_option_key = 'codesigner_checkout_builder_page_id';

			// save codesigner checkout builder page id
			if ( get_option( $cb_option_key ) != get_the_ID() ) {
				update_option( $cb_option_key, get_the_ID() );
			}
		}

        $settings           = $this->get_settings_for_display();
        $selected_template  = $settings['cd_checkout_template'];

		if ( is_null( WC()->cart ) ) {
			include_once WC_ABSPATH . 'includes/wc-cart-functions.php';
			include_once WC_ABSPATH . 'includes/class-wc-cart.php';
			wc_load_cart();
		}

		// print thank you page content
		if ( is_order_received_page() ) {
			$thank_you_slug = get_option( 'woocommerce_checkout_order_received_endpoint', 'order-received' );
			$order_id 		= get_query_var( $thank_you_slug );
			$order 			= wc_get_order( $order_id );

			wc_get_template( 'checkout/thankyou.php', ['order' => $order] );
		}

		// empty cart forefully add arandom product
		if ( WC()->cart->get_cart_contents_count() === 0 ) {
			global $wpdb;
			$product_id = 0;
		
			$random_product_id_query = "
				SELECT p.ID
				FROM {$wpdb->prefix}posts p
				WHERE p.post_type = 'product'
				AND p.post_status = 'publish'
				ORDER BY RAND()
				LIMIT 1
			";
		
			$product_id = $wpdb->get_var( $random_product_id_query );
			if ( $product_id ) {
				WC()->cart->add_to_cart( $product_id );
			}
		}

		// print template
		if ( $selected_template === 'default' ) {
			echo do_shortcode( '[woocommerce_checkout]' );
		}
		else {
			$args= array(
				'template-slug' 							=> $selected_template,
				'settings'      							=> $settings,
			);

			// render checkout template
			echo codesigner_get_checkout_template( $args );
		}

    }
}